<?php

	include 'config.php';

    $fp = fopen('./student_academic.csv', 'wa');
    //$fp = fopen('ftp://aimstapp@aimstuniversity.net:@aimst@1@ftp.aimstuniversity.net/pushed/student_academic.csv', 'wa');

    $student_academic = 'select
                    s.studentname,
                    s.icno,
                    s.matrixno,
                    rf.facultyname,
                    rc.coursename,
                    ri.intakeno,
                    ss.semester,
                    rs.subjectname,
                    ss.grade,
                    fss.name as subjectstatus,
                    sg.gpa,
                    sg.cgpa,
                    ras.name as academicstatus
                    from 
                    student s,
                    student_subject ss,
                    student_gpa sg,
                    ref_faculty rf,
                    ref_course rc,
                    ref_intake ri,
                    ref_subject rs,
                    fixed_subjectstatus fss,
                    ref_academic_status ras
                    where ss.studentid in (select studentid from student where status = 3) 
                    and ss.studentid = s.studentid
                    and ss.semesterid = sg.semesterid
                    and ss.semester = sg.semester
                    and ss.studentid = sg.studentid
                    and s.facultyid = rf.facultyid
                    and s.courseid = rc.courseid
                    and s.intakeid = ri.intakeid
                    and ss.subjectid = rs.subjectid
                    and ss.subjectstatus = fss.subjectstatusid
                    and sg.academicstatus = ras.id
                    and sg.published = 1
                    order by s.studentname,ss.semester,sg.semesterid';

    $res = mysqli_query($link,$student_academic);

    // fetch a row and write the column names out to the file
    $row = mysqli_fetch_assoc($res);
    $line = "";
    $comma = "";
    foreach($row as $name => $value) {
        $line .= $comma . '"' . str_replace('"', '""', $name) . '"';
        $comma = ",";
    }
    $line .= "\n";
    fputs($fp, $line);

    // remove the result pointer back to the start
    mysqli_data_seek($res, 0);

    // and loop through the actual data
    while($row = mysqli_fetch_assoc($res)) {
       
        $line = "";
        $comma = "";
        foreach($row as $value) {
            $line .= $comma . '"' . str_replace('"', '""', $value) . '"';
            $comma = ",";
        }
        $line .= "\n";
        fputs($fp, $line);
       
    }

    fclose($fp);

    //rename and move the file to the backup folder
    rename('ftp://'.$ftp_username.':'.$ftp_password.'@'.$ftp_host.'/student_academic.csv', 'ftp://'.$ftp_username.':'.$ftp_password.'@'.$ftp_host.'/backup/student_academic_'.$timestamp.'.csv');
    

    //copy from AIMST to AIMST APP
    $remote_file_url = "./student_academic.csv";
 
    /* New file name and path for this file */
    $local_file = 'ftp://'.$ftp_username.':'.$ftp_password.'@'.$ftp_host.'/student_academic.csv';
     
    /* Copy the file from source url to ftpserver */
    $copy = copy($remote_file_url,$local_file);
    
	//rename and move the local file to the backup folder
    rename("./student_academic.csv", "./backup/student_academic_$timestamp.csv");

    // unlink('./student_academic.csv');

?>
